#!/bin/bash

SRC_DIR=/var/lib/yandex/webmaster/wmc-logs
TOOLS="addurl delurl crawlurl rewriteurl reindexurl"
EXAMPLE_SUFFIX=.examples
TEMP_EXAMPLE_SUFFIX=$EXAMPLE_SUFFIX.tmp

shopt -s nullglob

cd "$SRC_DIR"
for tool in $TOOLS
do
  temp_file=$tool$TEMP_EXAMPLE_SUFFIX
  examples_file=$tool$EXAMPLE_SUFFIX
  
  > $SRC_DIR/$temp_file

  find $SRC_DIR -mmin -20 -name "$tool"'.*.*.txt' | xargs -n 10 cat >> $SRC_DIR/$temp_file

  rm -f $SRC_DIR/$examples_file
  mv -f $SRC_DIR/$temp_file $SRC_DIR/$examples_file
done