#!/bin/bash

log() {
  echo `date +"[%d/%b/%Y:%H:%M:%S]"`" $1"
}

log "Start rsync task: `date +'%F %T'`"

failed_rsyncs=0
ok_rsyncs=0

#options
RSYNC_FLAGS=--temp-dir=tmp

USER=corba
CORBA_RSYNC_PASSWORD="Ooc1mac5"

WMCUSER=wmcuser
WMCUSER_RSYNC_PASSWORD="HJXna28032"

# source
SRC_DIR=/var/lib/yandex/webmaster/support

CRAWLURL_SRC_NAME=$SRC_DIR/crawlurl.txt
CRAWLURL_TEMP_NAME=$CRAWLURL_SRC_NAME.tmp
CRAWLURL_LOG_SRC_NAME=$SRC_DIR/crawlurl-log.txt
CRAWLURL_LOG_SRC_NAME_TMP=$CRAWLURL_LOG_SRC_NAME.tmp

REWRITEURL_SRC_NAME=$SRC_DIR/rewriteurl.txt
REWRITEURL_TEMP_NAME=$REWRITEURL_SRC_NAME.tmp
REWRITEURL_LOG_SRC_NAME=$SRC_DIR/rewriteurl-log.txt
REWRITEURL_LOG_SRC_NAME_TMP=$REWRITEURL_LOG_SRC_NAME.tmp

#destination
TARGET_HOST=lya.search.yandex.net
TARGET_DIR=addurl
CRAWLURL_TARGET_NAME=crawlurl.`hostname`.`date "+%F"`.txt
REWRITEURL_TARGET_NAME=rewriteurl.`hostname`.`date "+%F"`.txt
TARGET_RSYNC_URI=$USER@$TARGET_HOST::$TARGET_DIR

#aggregate host
AGGREGATE_LOG_TARGET_HOST=wmc-admin01d.search.yandex.net
AGGREGATE_LOG_TARGET_DIR=wmc-logs
AGGREGATE_LOG_RSYNC_URI=$WMCUSER@$AGGREGATE_LOG_TARGET_HOST::$AGGREGATE_LOG_TARGET_DIR

#copy urls from crawlurl
if [ -f $CRAWLURL_SRC_NAME ]
then
  mv $CRAWLURL_SRC_NAME $CRAWLURL_TEMP_NAME
  RSYNC_PASSWORD=$CORBA_RSYNC_PASSWORD
  export RSYNC_PASSWORD
  rsync $RSYNC_FLAGS $CRAWLURL_TEMP_NAME $TARGET_RSYNC_URI/$CRAWLURL_TARGET_NAME
  rsyncStatus="$?"
  if [ ${rsyncStatus} -ne 0 ]; then
    log "rsync error while sending $CRAWLURL_TEMP_NAME: ${rsyncStatus}"
    failed_rsyncs=$(($failed_rsyncs + 1))
  fi
  ok_rsyncs=$(($ok_rsyncs + 1))
fi

#copy urls from rewriteurl
if [ -f $REWRITEURL_SRC_NAME ]
then
  mv $REWRITEURL_SRC_NAME $REWRITEURL_TEMP_NAME
  RSYNC_PASSWORD=$CORBA_RSYNC_PASSWORD
  export RSYNC_PASSWORD
  rsync $RSYNC_FLAGS $REWRITEURL_TEMP_NAME $TARGET_RSYNC_URI/$REWRITEURL_TARGET_NAME
  rsyncStatus="$?"
  if [ ${rsyncStatus} -ne 0 ]; then
    log "rsync error while sending $REWRITEURL_TEMP_NAME: ${rsyncStatus}"
    failed_rsyncs=$(($failed_rsyncs + 1))
  fi
  ok_rsyncs=$(($ok_rsyncs + 1))
fi

# Copy logs from crawlurl
if [ -f $CRAWLURL_LOG_SRC_NAME ]; then
  mv $CRAWLURL_LOG_SRC_NAME $CRAWLURL_LOG_SRC_NAME_TMP
  RSYNC_PASSWORD=$WMCUSER_RSYNC_PASSWORD
  export RSYNC_PASSWORD
  rsync $RSYNC_FLAGS $CRAWLURL_LOG_SRC_NAME_TMP $AGGREGATE_LOG_RSYNC_URI/$CRAWLURL_TARGET_NAME
  rsyncStatus="$?"
  if [ ${rsyncStatus} -ne 0 ]; then
    log "rsync error while sending $CRAWLURL_LOG_SRC_NAME_TMP: ${rsyncStatus}"
    failed_rsyncs=$(($failed_rsyncs + 1))
  fi
  ok_rsyncs=$(($ok_rsyncs + 1))
fi

# Copy logs from rewriteurl
if [ -f $REWRITEURL_LOG_SRC_NAME ]; then
  mv $REWRITEURL_LOG_SRC_NAME $REWRITEURL_LOG_SRC_NAME_TMP
  RSYNC_PASSWORD=$WMCUSER_RSYNC_PASSWORD
  export RSYNC_PASSWORD
  rsync $RSYNC_FLAGS $REWRITEURL_LOG_SRC_NAME_TMP $AGGREGATE_LOG_RSYNC_URI/$REWRITEURL_TARGET_NAME
  rsyncStatus="$?"
  if [ ${rsyncStatus} -ne 0 ]; then
    log "rsync error while sending $REWRITEURL_LOG_SRC_NAME_TMP: ${rsyncStatus}"
    failed_rsyncs=$(($failed_rsyncs + 1))
  fi
  ok_rsyncs=$(($ok_rsyncs + 1))
fi

log "Task finished"
log "statistics: success=${ok_rsyncs} error=${failed_rsyncs}"
