#!/bin/bash

log() {
  echo `date +"[%d/%b/%Y:%H:%M:%S]"`" $1"
}

log "Start rsync2 task: `date +'%F %T'`"

failed_rsyncs=0
ok_rsyncs=0

#rsync options
RSYNC_FLAGS=--temp-dir=tmp
CORBA_RSYNC_PASSWORD="Ooc1mac5"

_TMP_EXTENSION=".tmp"
_TMP_FAILED_EXTENSION=".tmp.failed"

prepare_file() {
  local fullFilePath="$1"
  local tmpFilePath="$2"
  local tmpFailedPath="$3"

  mv "${fullFilePath}" "${tmpFilePath}"
  # append data from previous try
  if [ -f "${tmpFailedPath}" ]; then
    cat "${tmpFailedPath}" >> "${tmpFilePath}"
    rm -f "${tmpFailedPath}"
  fi

  return 0
}

do_rsync() {
  local tmpFilePath="$1"
  local rsyncTarget="$2"
  local tmpFailedPath="$3"
  local rsyncFlags="${4:-${RSYNC_FLAGS}}"

  log "Rsync ${tmpFilePath} to ${rsyncTarget}"

  rsync ${rsyncFlags} "${tmpFilePath}" "${rsyncTarget}"
  # save urls if rsync exit code is not successful
  # these urls will be send with the next portion
  local rsyncStatus="$?"
  if [ ${rsyncStatus} -ne 0 ]; then
    mv -f "${tmpFilePath}" "${tmpFailedPath}"
    log "Rsync falied(${rsyncStatus}). Move file to ${tmpFailedPath}"
    failed_rsyncs=$(($failed_rsyncs + 1))
    return 1
  fi
  ok_rsyncs=$(($ok_rsyncs + 1))
  return 0
}

rsync_file() {
  local folder="$1"
  local fileName="$2"
  local rsyncTarget="$3"
  local rsyncFlags="$4"

  local fullFilePath="$1/$2"
  local tmpFilePath="${fullFilePath}${_TMP_EXTENSION}"
  local tmpFailedPath="${fullFilePath}${_TMP_FAILED_EXTENSION}"

  log "Rsync ${fullFilePath}"

  if [ ! -f "${fullFilePath}" ]; then
    log "File not found: ${fullFilePath}"
    return 1
  fi

  prepare_file "${fullFilePath}" "${tmpFilePath}" "${tmpFailedPath}"
  do_rsync "${tmpFilePath}" "${rsyncTarget}" "${tmpFailedPath}" "${rsyncFlags}"
}


USER="corba"

#destination
REALFEED00_TARGET_HOST="realfeed00.search.yandex.net"
REALFEED01_TARGET_HOST="realfeed01.search.yandex.net"
REALFEED_TARGET_DIR="fasturls"
REALFEED_TARGET_NAME=reindexurl.$(hostname).$(date "+%s").txt
REALFEED_TARGET_NAME_TR=reindexurl_tr.$(hostname).$(date "+%s").txt
REALFEDD00_RSYNC_URI="${USER}@${REALFEED00_TARGET_HOST}::${REALFEED_TARGET_DIR}"
REALFEDD01_RSYNC_URI="${USER}@${REALFEED01_TARGET_HOST}::${REALFEED_TARGET_DIR}"

FRQ_TARGET_HOST="wspm.search.yandex.net"
FRQ_TARGET_DIR="imp-wmc"
FRQ_TARGET_NAME=reindexurl.$(hostname).$(date "+%F-%H-%M").txt
FRQ_TARGET_NAME_TR=reindexurl_tr.$(hostname).$(date "+%F-%H-%M").txt
FRQ_RSYNC_URI="${USER}@${FRQ_TARGET_HOST}::${FRQ_TARGET_DIR}"

#aggregate host
WMCUSER="wmcuser"
WMCUSER_RSYNC_PASSWORD="HJXna28032"
AGGREGATE_LOG_TARGET_HOST="wmc-admin01d.search.yandex.net"
AGGREGATE_LOG_TARGET_DIR="wmc-logs"
AGGREGATE_LOG_RSYNC_URI="${WMCUSER}@${AGGREGATE_LOG_TARGET_HOST}::${AGGREGATE_LOG_TARGET_DIR}"

#source
SRC_DIR="/var/lib/yandex/webmaster/support"

REINDEXURL_TXT="reindexurl.txt"
REINDEXURL_TXT_00="reindexurl.00.txt"
REINDEXURL_TXT_01="reindexurl.01.txt"
REINDEXURL_FRQ_TXT="reindexurl.frq.txt"

REINDEXURL_FULLPATH="${SRC_DIR}/${REINDEXURL_TXT}"
REINDEXURL_FULLPATH_00="${SRC_DIR}/${REINDEXURL_TXT_00}"
REINDEXURL_FULLPATH_01="${SRC_DIR}/${REINDEXURL_TXT_01}"
REINDEXURL_FRQ_FULLPATH="${SRC_DIR}/${REINDEXURL_FRQ_TXT}"

if [ -f "${REINDEXURL_FULLPATH}" ]
then
  cat "${REINDEXURL_FULLPATH}" | sed "s,^http://,," > $REINDEXURL_FRQ_FULLPATH
  cp "${REINDEXURL_FULLPATH}" "${REINDEXURL_FULLPATH_00}"
  mv "${REINDEXURL_FULLPATH}" "${REINDEXURL_FULLPATH_01}"
fi
export RSYNC_PASSWORD="$CORBA_RSYNC_PASSWORD"
rsync_file "${SRC_DIR}" "${REINDEXURL_TXT_00}" "${REALFEDD00_RSYNC_URI}/${REALFEED_TARGET_NAME}" "--temp-dir=temp"
rsync_file "${SRC_DIR}" "${REINDEXURL_TXT_01}" "${REALFEDD01_RSYNC_URI}/${REALFEED_TARGET_NAME}" "--temp-dir=temp"
rsync_file "${SRC_DIR}" "${REINDEXURL_FRQ_TXT}" "${FRQ_RSYNC_URI}/${FRQ_TARGET_NAME}"


REINDEXURL_TR_TXT="reindexurl_tr.txt"
REINDEXURL_TR_TXT_00="reindexurl_tr.00.txt"
REINDEXURL_TR_TXT_01="reindexurl_tr.01.txt"
REINDEXURL_TR_FRQ_TXT="reindexurl_tr.frq.txt"

REINDEXURL_TR_FULLPATH="${SRC_DIR}/${REINDEXURL_TR_TXT}"
REINDEXURL_TR_FULLPATH_00="${SRC_DIR}/${REINDEXURL_TR_TXT_00}"
REINDEXURL_TR_FULLPATH_01="${SRC_DIR}/${REINDEXURL_TR_TXT_01}"
REINDEXURL_TR_FRQ_FULLPATH="${SRC_DIR}/${REINDEXURL_TR_FRQ_TXT}"

if [ -f "${REINDEXURL_TR_FULLPATH}" ]
then
  cat "${REINDEXURL_TR_FULLPATH}" | sed "s,^http://,," > ${REINDEXURL_TR_FRQ_FULLPATH}
  cp "${REINDEXURL_TR_FULLPATH}" "${REINDEXURL_TR_FULLPATH_00}"
  mv "${REINDEXURL_TR_FULLPATH}" "${REINDEXURL_TR_FULLPATH_01}"  
fi
export RSYNC_PASSWORD="$CORBA_RSYNC_PASSWORD"
rsync_file "${SRC_DIR}" "${REINDEXURL_TR_TXT_00}" "${REALFEDD00_RSYNC_URI}/${REALFEED_TARGET_NAME_TR}" "--temp-dir=temp"
rsync_file "${SRC_DIR}" "${REINDEXURL_TR_TXT_01}" "${REALFEDD01_RSYNC_URI}/${REALFEED_TARGET_NAME_TR}" "--temp-dir=temp"
rsync_file "${SRC_DIR}" "${REINDEXURL_TR_FRQ_TXT}" "${FRQ_RSYNC_URI}/${FRQ_TARGET_NAME_TR}"


# Copy logs
REINDEXURL_LOG_TXT="reindexurl-log.txt"
REINDEXURL_LOG_TR_TXT="reindexurl-log_tr.txt"

export RSYNC_PASSWORD="$WMCUSER_RSYNC_PASSWORD"
rsync_file "${SRC_DIR}" "${REINDEXURL_LOG_TXT}" "${AGGREGATE_LOG_RSYNC_URI}/${FRQ_TARGET_NAME}"
rsync_file "${SRC_DIR}" "${REINDEXURL_LOG_TR_TXT}" "${AGGREGATE_LOG_RSYNC_URI}/${FRQ_TARGET_NAME_TR}"

log "Task finished"
log "statistics: success=${ok_rsyncs} error=${failed_rsyncs}"
