package ru.yandex.wmtools.common.authorization;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.service.IUserIdService;

/**
 * @author ailyin
 */
public class PassportAuthorizationScheme implements AuthorizationScheme {
    private final IUserIdService userIdService;

    public PassportAuthorizationScheme(IUserIdService userIdService) {
        this.userIdService = userIdService;
    }

    @Override
    public long getUserId(ServRequest req, ServResponse res) throws UserException, InternalException {
        return userIdService.getAndCheckUserId(req, res);
    }
}
