package ru.yandex.wmtools.common.data;

/**
 * @author aherman
 */
public class DbBanConfig {
    private static final int DEFAULT_ERRORS_TO_BAN = 5; // after how many query attempts with error master-base should be banned.
    private static final int DEFAULT_BAN_ATTEMPTS_COUNT = 1000; // how many times queries will be rejected.
    private static final int DEFAULT_BAN_TIME_IN_MILLISECONDS = 1000 * 60 * 5; // ban time in milliseconds

    private int errortToBan = DEFAULT_ERRORS_TO_BAN;
    private int banAttemptCount = DEFAULT_BAN_ATTEMPTS_COUNT;
    private int banTimeMilliseconds = DEFAULT_BAN_TIME_IN_MILLISECONDS;

    public void setErrortToBan(int errortToBan) {
        this.errortToBan = errortToBan;
    }

    public int getErrortToBan() {
        return errortToBan;
    }

    public void setBanAttemptCount(int banAttemptCount) {
        this.banAttemptCount = banAttemptCount;
    }

    public int getBanAttemptCount() {
        return banAttemptCount;
    }

    public void setBanTimeMilliseconds(int banTimeMilliseconds) {
        this.banTimeMilliseconds = banTimeMilliseconds;
    }

    public int getBanTimeMilliseconds() {
        return banTimeMilliseconds;
    }
}
