package ru.yandex.wmtools.common.data;

public enum HistoryActionEnum implements IHistoryAction {
    ADD((byte) 0),
    REMOVE((byte) 1),
    EDIT((byte) 3),

    // only values more than 3 can be added!
    ;

    private byte value;

    public static HistoryActionEnum getByValue(byte value) {
        for (HistoryActionEnum historyAction : values()) {
            if (value == historyAction.value) {
                return historyAction;
            }
        }

        return null;
    }

    HistoryActionEnum(byte value) {
        this.value = value;
    }

    @Override
    public byte getValue() {
        return value;
    }
}
