package ru.yandex.wmtools.common.data;

import java.util.ArrayList;
import java.util.List;

public enum HistoryObjectTypeEnum implements IHistoryObjectType {
    SUPPORT_USER((byte) 0, true),
    BLOCKED_USER((byte) 1, true),
    USER((byte) 6, true);
    // only values more than 6 can be added!

    private static List<IHistoryObjectType> objeftsOfUserList;

    private byte value;
    private boolean isObjectOfUser;

    public static HistoryObjectTypeEnum getByValue(byte value) {
        for (HistoryObjectTypeEnum objectType : values()) {
            if (value == objectType.value) {
                return objectType;
            }
        }

        return null;
    }

    HistoryObjectTypeEnum(byte value, boolean isObjectOfUser) {
        this.value = value;
        this.isObjectOfUser = isObjectOfUser;
    }

    @Override
    public byte getValue() {
        return value;
    }

    @Override
    public boolean isObjectOfUser() {
        return isObjectOfUser;
    }

    public static List<IHistoryObjectType> listObjectsOfUser() {
        if (objeftsOfUserList == null) {
            ArrayList<IHistoryObjectType> result = new ArrayList<IHistoryObjectType>();
            for (IHistoryObjectType value : values()) {
                if (value.isObjectOfUser()) {
                    result.add(value);
                }
            }
            objeftsOfUserList = result;
        }

        return objeftsOfUserList;
    }
}
