package ru.yandex.wmtools.common.data.info;

import ru.yandex.wmtools.common.data.IHistoryAction;
import ru.yandex.wmtools.common.data.IHistoryObjectType;

import java.util.Date;

/**
 * Created by IntelliJ IDEA.
* User: senin
* Date: 22.03.2007
* Time: 15:45:34
*/
public class HistoryInfo {
    private final long id;
    private final WMUserInfo user;
    private final WMUserInfo virtualUser;
    private final WMUserInfo objectUser;
    private final long objectId;
    private final Date performedOn;
    private final IHistoryAction action;
    private final IHistoryObjectType type;
    private final String newValue;

    public HistoryInfo(long id, WMUserInfo user, WMUserInfo virtualUser, IHistoryAction action, long objectId, Date performedOn, IHistoryObjectType type) {
        this(id, user, virtualUser, action, objectId, performedOn, type, null, null);
    }

    public HistoryInfo(long id, WMUserInfo user, WMUserInfo virtualUser, IHistoryAction action, long objectId, Date performedOn, IHistoryObjectType type, WMUserInfo objectUser) {
        this(id, user, virtualUser, action, objectId, performedOn, type, objectUser, null);
    }

    public HistoryInfo(long id, WMUserInfo user, WMUserInfo virtualUser, IHistoryAction action, long objectId, Date performedOn, IHistoryObjectType type, String newValue) {
        this(id, user, virtualUser, action, objectId, performedOn, type, null, newValue);
    }

    public HistoryInfo(long id, WMUserInfo user, WMUserInfo virtualUser, IHistoryAction action, long objectId, Date performedOn, IHistoryObjectType type, WMUserInfo objectUser, String newValue) {
        this.id = id;
        this.user = user;
        this.virtualUser = virtualUser;
        this.action = action;
        this.objectId = objectId;
        this.performedOn = performedOn;
        this.type = type;
        this.objectUser = objectUser;
        this.newValue = newValue;
    }

    public long getId() {
        return id;
    }

    public WMUserInfo getUser() {
        return user;
    }

    public WMUserInfo getVirtualUser() {
        return virtualUser;
    }

    public IHistoryAction getAction() {
        return action;
    }

    public long getObjectId() {
        return objectId;
    }

    public Date getPerformedOn() {
        return performedOn;
    }

    public IHistoryObjectType getType() {
        return type;
    }

    public WMUserInfo getObjectUser() {
        return objectUser;
    }

    public String getNewValue() {
        return newValue;
    }
}
