package ru.yandex.wmtools.common.data.info;

import ru.yandex.wmtools.common.data.RegionTypeEnum;

/**
 * Date: May 13, 2009
 *
 * @author yakushev
 */
public class HostRegionInfo {
    private final RegionInfo regionInfo;
    private final RegionTypeEnum regionType;
    private final boolean visible;

    public HostRegionInfo(RegionInfo regionInfo, RegionTypeEnum regionType, boolean visible) {
        this.regionInfo = regionInfo;
        this.regionType = regionType;
        this.visible = visible;
    }

    public RegionInfo getRegionInfo() {
        return regionInfo;
    }

    public RegionTypeEnum getRegionType() {
        return regionType;
    }

    public boolean isVisible() {
        return visible;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        HostRegionInfo that = (HostRegionInfo) o;

        return regionType == that.regionType && !(regionInfo != null ? !regionInfo.equals(that.regionInfo) : that.regionInfo != null);
    }

    @Override
    public int hashCode() {
        int result = regionInfo != null ? regionInfo.hashCode() : 0;
        result = 31 * result + (regionType != null ? regionType.hashCode() : 0);
        return result;
    }
}
