package ru.yandex.wmtools.common.data.info;

/**
 * @author avhaliullin
 */
public class OAuthScope {
    private final String service;
    private final String rights;

    public OAuthScope(String service, String rights) {
        this.service = service;
        this.rights = rights;
    }

    public OAuthScope(String scope) {
        this(scope.split(":")[0], scope.split(":")[1]);
    }

    public String getService() {
        return service;
    }

    public String getRights() {
        return rights;
    }

    public int hashCode() {
        return service.hashCode() + rights.hashCode();
    }

    public boolean equals(Object scope) {
        return (scope instanceof OAuthScope) &&
                service.equals(((OAuthScope) scope).getService()) &&
                rights.equals(((OAuthScope) scope).getRights());
    }

    public String toString() {
        return service + ":" + rights;
    }
}
