package ru.yandex.wmtools.common.data.info;

import java.util.Arrays;
import java.util.Collection;

import org.jetbrains.annotations.Nullable;

import ru.yandex.wmtools.common.service.RegionIds;

/**
 * Date: May 13, 2009
 *
 * @author yakushev
 */
public class RegionInfo {
    public static final byte GEOTYPE_COUNTRY = 3;
    public static final byte GEOTYPE_CITY = 6;

    public static final Collection<Integer> emptyRegions = Arrays.asList(
            RegionIds.ROOT_REGION_ID,
            29,
            318
    );

    public static final RegionInfo zeroRegion =
            new RegionInfo(
                    RegionIds.ROOT_REGION_ID,
                    (byte) 0, (byte) 0, 0, (byte) 0
            );

    public static final RegionInfo wholeWorldRegion =
            new RegionInfo(
                    RegionIds.EARTH_REGION_ID,
                    (byte) 0, (byte) 0, 0, (byte) 0
            );

    private final int id;
    private final byte type;
    private final byte geotype;
    private final byte hide;
    private final int parent;

    private RegionName regionName;

    public RegionInfo(int id, byte type, byte hide, int parent, byte geotype) {
        this.id = id;
        this.type = type;
        this.geotype = geotype;
        this.hide = hide;
        this.parent = parent;
    }

    public int getId() {
        if (isEmpty()) {
            return zeroRegion.id;
        } else {
            return id;
        }
    }

    public int getRealId() {
        return id;
    }

    public boolean isEmpty() {
        return emptyRegions.contains(id);
    }

    public byte getType() {
        return type;
    }

    public byte getGeotype() {
        return geotype;
    }

    public byte getHide() {
        return hide;
    }

    public int getParent() {
        return parent;
    }

    public String toString() {
        return "RegionInfo. " +
                "id: " + id + ", " +
                "name: " + ((regionName == null) ? "(null)" : regionName.getRuName()) + ", " +
                "type: " + type + ", " +
                "hide: " + hide + ", " +
                "parent: " + parent;
    }

    public String getDefaultName() {
        if (regionName != null) {
            return regionName.getRuName();
        }
        return "region_id=" + id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        RegionInfo that = (RegionInfo) o;

        return id == that.id;
    }

    @Override
    public int hashCode() {
        return id;
    }

    public void setRegionName(RegionName regionName) {
        this.regionName = regionName;
    }

    @Nullable
    public RegionName getRegionName() {
        return regionName;
    }
}
