package ru.yandex.wmtools.common.data.info;

import java.util.ArrayList;
import java.util.List;

/**
 * @author baton
 */
public class RegionInfoTreeNode {
    private RegionInfo regionInfo;
    private RegionInfoTreeNode parent;
    private final List<RegionInfoTreeNode> children = new ArrayList<RegionInfoTreeNode>();
    private final boolean enabled;

    public RegionInfoTreeNode() {
        this.enabled = true;
    }

    public RegionInfoTreeNode(final boolean enabled) {
        this.enabled = enabled;
    }

    public void setWholeRegionInfo(RegionInfo regionInfo, RegionInfoTreeNode parent) {
        this.regionInfo = regionInfo;
        this.parent = parent;
    }

    public void setRegionInfo(RegionInfo regionInfo) {
        this.regionInfo = regionInfo;
    }

    public void setParent(RegionInfoTreeNode parent) {
        this.parent = parent;
    }

    public RegionInfo getRegionInfo() {
        return regionInfo;
    }

    public RegionInfoTreeNode getParent() {
        return parent;
    }

    public List<RegionInfoTreeNode> getChildren() {
        return children;
    }

    public boolean isEnabled() {
        return enabled;
    }
}
