package ru.yandex.wmtools.common.data.info;

import java.util.ArrayList;
import java.util.List;

// TODO ������� ���� ����� � ����� TopInfoItem �����������
public class TopInfo<T extends TopInfoItem, TTL extends TotalsInfo> {
    public enum TopInfoErrorEnum {
        NOT_A_KEY_REGION,
        DATE_NOT_SPECIFIED,
    }

    // TODO ��������, ����� ������ ������������ �� ���, � � ���� UserException � ���� �� ������� �� �����������
    public static TopInfo notAKeyRegion = new TopInfo<TopInfoItem, TotalsInfo>(
            new ArrayList<TopInfoItem>(), new TotalsInfo(0, 0), TopInfoErrorEnum.NOT_A_KEY_REGION);
    public static TopInfo dateNotSpecified = new TopInfo<TopInfoItem, TotalsInfo>(
            new ArrayList<TopInfoItem>(), new TotalsInfo(0, 0), TopInfoErrorEnum.DATE_NOT_SPECIFIED);
    public static TopInfo empty = new TopInfo<TopInfoItem, TotalsInfo>(
            new ArrayList<TopInfoItem>(), new TotalsInfo(0, 0), null);

    private final List<T> topItems;
    private final TTL totalsInfo;
    private final TopInfoErrorEnum error;

    public TopInfo(List<T> topItems, TTL totalsInfo, TopInfoErrorEnum error) {
        this.topItems = topItems;
        this.totalsInfo = totalsInfo;
        this.error = error;
    }

    public List<T> getTopItems() {
        return topItems;
    }

    public TTL getTotalsInfo() {
        return totalsInfo;
    }

    public TopInfoErrorEnum getError() {
        return error;
    }
}
