package ru.yandex.wmtools.common.data.info;

import ru.yandex.wmtools.common.service.TopTypeEnum;

public class TopInfoItem {
    private final String query;
    private final int shows;
    private final int clicks;
    private final long queryId;
    private Integer showsTopRank;
    private Integer clicksTopRank;
    private final boolean isCustom;
    private boolean hasHistory;

    public TopInfoItem(long queryId, String query, int shows, int clicks, boolean isCustom, Integer customQueryShowsTopRank, Integer customQueryClicksTopRank, boolean hasHistory) {
        this.queryId = queryId;
        this.query = query;
        this.shows = shows;
        this.clicks = clicks;

        this.showsTopRank = customQueryShowsTopRank;
        this.clicksTopRank = customQueryClicksTopRank;
        this.isCustom = isCustom;
        this.hasHistory = hasHistory;
    }

    public void setTopRankIfNotCustom(TopTypeEnum topType, Integer rank) {
        if (!isCustom) {
            switch (topType) {
                case CLICKS: {
                    clicksTopRank = rank;
                    break;
                }
                case SHOWS: {
                    showsTopRank = rank;
                    break;
                }
                default: {
                    throw new AssertionError("Unknown TopTypeEnum: " + topType);
                }
            }
        }
    }


    public void setHasHistory(boolean hasHistory) {
        this.hasHistory = hasHistory;
    }

    public String getQuery() {
        return query;
    }

    public int getShows() {
        return shows;
    }

    public int getClicks() {
        return clicks;
    }

    public long getQueryId() {
        return queryId;
    }

    public Integer getTopRank(TopTypeEnum type) {
        if (TopTypeEnum.CLICKS.equals(type)) {
            return getClicksTopRank();
        } else if (TopTypeEnum.SHOWS.equals(type)) {
            return getShowsTopRank();
        } else {
            throw new AssertionError("Unknown value of TopTypeEnum: " + type);
        }
    }

    public Integer getShowsTopRank() {
        return showsTopRank;
    }

    public Integer getClicksTopRank() {
        return clicksTopRank;
    }

    public boolean isCustom() {
        return isCustom;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if ((o == null) || (getClass() != o.getClass())) {
            return false;
        }

        TopInfoItem that = (TopInfoItem) o;
        if ((query != null) ? !query.equals(that.query) : that.query != null) {
            return false;
        }
        if (queryId != that.queryId) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = query != null ? query.hashCode() : 0;
        result = 31 * result + new Long(queryId).hashCode();
        return result;
    }

    public boolean hasHistory() {
        return hasHistory;
    }
}
