package ru.yandex.wmtools.common.data.info;

import java.util.Date;

/**
 * Statistics of service usage.
 *
 * @author baton
*/
public class VisitingStatInfo {
    private final Long user;
    private final int requestTypeId;
    private final String requestTypeName;
    private final Date date;
    private final int requestsCount;

    /**
     * Stores request count for given request type, date and user.
     * User can be null. This means, that statistics are summary for all users.
     *
     * @param user can be null. This means, that statistics are summary for all users.
     * @param requestTypeId for what request type (id)
     * @param requestTypeName for what request type (name)
     * @param date for what date
     * @param requestsCount how many requests were made on given day and given request type by given user
     */
    public VisitingStatInfo(Long user, int requestTypeId, String requestTypeName, Date date, int requestsCount) {
        this.user = user;
        this.requestTypeId = requestTypeId;
        this.requestTypeName = requestTypeName;
        this.date = date;
        this.requestsCount = requestsCount;
    }

    public Long getUser() {
        return user;
    }

    public int getRequestTypeId() {
        return requestTypeId;
    }

    public String getRequestTypeName() {
        return requestTypeName;
    }

    public Date getDate() {
        return date;
    }

    public int getRequestsCount() {
        return requestsCount;
    }
}
