package ru.yandex.wmtools.common.data.info;

import org.jetbrains.annotations.Nullable;
import ru.yandex.common.framework.user.UserInfo;
import ru.yandex.common.framework.user.UserInfoField;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 27.07.2007
 * Time: 15:11:37
 */
public class WMUserInfo {
    private final long userId;
    private final boolean isSupport;
    private final boolean isBlocked;
    private final UserInfo userInfo;

    public WMUserInfo(long userId, UserInfo userInfo, boolean isSupport, boolean isBlocked) {
        this.userId = userId;
        this.isSupport = isSupport;
        this.isBlocked = isBlocked;
        this.userInfo = userInfo;
    }

    public long getUserId() {
        return userId;
    }

    public boolean isSupport() {
        return isSupport;
    }

    public boolean isBlocked() {
        return isBlocked;
    }


    public String getLogin() {
        if (userInfo == null) {
            return null;
        }

        return userInfo.getLogin();
    }

    public String getFIO() {
        if (userInfo == null) {
            return null;
        }
        return userInfo.getValue(UserInfoField.FIO);
    }

    @Nullable
    public UserInfo getUserInfo() {
        return userInfo;
    }
}
