package ru.yandex.wmtools.common.data.mapper;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import ru.yandex.common.util.collections.Pair;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * @author avhaliullin
 */
public class CompositePairMapper<A, B> implements ParameterizedRowMapper<Pair<A, B>> {
    private final ParameterizedRowMapper<A> aMapper;
    private final ParameterizedRowMapper<B> bMapper;

    public CompositePairMapper(ParameterizedRowMapper<A> aMapper, ParameterizedRowMapper<B> bMapper) {
        this.aMapper = aMapper;
        this.bMapper = bMapper;
    }

    @Override
    public Pair<A, B> mapRow(ResultSet rs, int rowNum) throws SQLException {
        return Pair.of(aMapper.mapRow(rs, rowNum), bMapper.mapRow(rs, rowNum));
    }
}
