/**
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Yandex</p>
 * <p>Date: 08.08.2006</p>
 * <p>Time: 11:43:22</p>
 */
package ru.yandex.wmtools.common.data.multidbpager;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;
import ru.yandex.wmtools.common.servantlet.AbstractServantlet;

/**
 * @author baton
 */
public class SimpleMultiDbPagerFactory<T> implements MultiDbPagerFactory<T> {
    private static final String PARAM_DBINDEX = "dbindex";
    private static final String PARAM_SORT = "sort";

    private static final int DEFAULT_PAGE_SIZE = 20;
    private int defaultPageSize = DEFAULT_PAGE_SIZE;

    public void setDefaultPageSize(final int defaultPageSize) {
        this.defaultPageSize = defaultPageSize;
    }

    @Override
    public MultiDbPager<T> createPager(final ServRequest req, final ISortStrategyEnum<T> defaultSortStrategy) throws UserException {
        int pageSize = req.getParamAsInt("page_size", defaultPageSize);
        if (pageSize <= 0) {
            pageSize = defaultPageSize;
        }
        return createPager(req, defaultSortStrategy, pageSize);
    }

    @Override
    public MultiDbPager<T> createPager(final ServRequest req, final ISortStrategyEnum<T> defaultSortStrategy, final int pageSize) throws UserException {
        final boolean showAll = req.getCheckBoxParamAsBoolean("show_all", false);
        SortStrategy<T> sortStrategy = getSortStrategy(req, defaultSortStrategy);
        return new MultiDbPager<T>(pageSize, readDbIndexParams(req), showAll, sortStrategy);
    }

    private SortStrategy<T> getSortStrategy(final ServRequest req, final ISortStrategyEnum<T> defaultSortStrategy) throws UserException {
        SortStrategy<T> sortStrategy = defaultSortStrategy.getSortStrategy(req);

        String sortStrategyStr = req.getParam(PARAM_SORT, true);
        if (!StringUtils.isBlank(sortStrategyStr)) {
            ISortStrategyEnum<T> sortStrategyEnum = defaultSortStrategy.getByName(sortStrategyStr);
            if (sortStrategyEnum == null) {
                throw new UserException(UserProblem.SUCH_VALUE_NOT_ALLOWED_HERE, "Value " + sortStrategyStr + " is not allowed for parameter " + PARAM_SORT);
            } else {
                sortStrategy = sortStrategyEnum.getSortStrategy(req);
            }
        }

        return sortStrategy;
    }

    private int[] readDbIndexParams(ServRequest req) throws UserException {
        List<Integer> dbIndexList = new ArrayList<Integer>();
        int dbCount = 0;
        while (true) {
            Integer nextInt = AbstractServantlet.getIntParam(req, PARAM_DBINDEX + dbCount);
            if (nextInt == null) {
                break;
            }
            dbIndexList.add(nextInt);
            dbCount++;
        }

        int[] res = null;
        if (dbCount > 0) {
            Integer[] dbIndex = new Integer[dbCount];
            dbIndex = dbIndexList.toArray(dbIndex);

            res = new int[dbCount];
            for (int i = 0; i < dbIndex.length; i++) {
                res[i] = dbIndex[i];
            }
        }
        return res;
    }
}
