package ru.yandex.wmtools.common.data.partition;

/**
 * @author baton
 * Date: 04.02.2009
 * Time: 18:10:53
 */
public interface IPartition {
    /**
     * Returns sql string, where indices of tables are already inserted.
     *
     * @param sqlString Source sql string, without any indices.
     * @return Ready sql string.
     */
    String getReadySqlString(String sqlString);

    /**
     * Returns index of database, with which we need to interact.
     *
     * @param baseCount Number of databases available.
     * @return Database index.
     */
    int getDatabaseIndex(int baseCount);

    /**
     * Returns IPartition object for given database index.
     *
     * @param dbIndex Index of database.
     * @return IPartition object for given database index.
     */
    IPartition getIPartitionForDb(int dbIndex);
}
