package ru.yandex.wmtools.common.data.plot;

import java.util.Date;

/**
 * @author avhaliullin
 */
public abstract class DateNumberPlotHelper<V extends Number> extends DatePlotHelper<V> {
    public DateNumberPlotHelper(InterpolateMode interpolateMode) {
        super(interpolateMode);
    }

    @Override
    public String formatValue(V value) {
        return value.toString();
    }

    @Override
    public V interpolate(Date key1, V value1, Date key2, V value2, Date key) {
        switch (getInterpolateMode()) {
            case NULL: {
                return null;
            }
            case PREV: {
                return value1;
            }
            case LINEAR: {
                if (value1 == null || value2 == null) {
                    return null;
                }

                long diff = key2.getTime() - key1.getTime();
                if (diff == 0) {
                    return getZero();
                }
                long diff2Key = key2.getTime() - key.getTime();
                long diffKey1 = key.getTime() - key1.getTime();
                return getByNumber((value1.doubleValue() * diff2Key + value2.doubleValue() * diffKey1) / diff);
            }
            case ZERO: {
                return getZero();
            }
            default: {
                throw new AssertionError("Unknown interpolation mode: " + getInterpolateMode());
            }
        }
    }

    public V getZero() {
        return getByNumber(0);
    }

    protected abstract V getByNumber(Number n);
}
