package ru.yandex.wmtools.common.data.plot;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 29.10.2008
 * Time: 20:23:24
 */
public abstract class DatePlotHelper<V> implements PlotHelper<Date, V> {
    private InterpolateMode interpolateMode = InterpolateMode.PREV;
    private DateFormat dateFormat = new SimpleDateFormat("dd.MM.yy");
    private boolean needGaps = false;
    private int timeUnit = Calendar.DATE;
    private int period = 1;
    private TreeSet<Date> series;

    @Override
    public boolean isNeedGaps() {
        return needGaps;
    }

    @Override
    public boolean mustContainKey(Date key) {
        return series == null || series.contains(key);
    }

    public DatePlotHelper(InterpolateMode interpolateMode) {
        this.interpolateMode = interpolateMode;
    }

    public void setPeriodDays(int periodDays) {
        this.period = periodDays;
        this.timeUnit = Calendar.DATE;
    }

    public void setPeriod(int periodDays, int timeUnit) {
        this.period = periodDays;
        this.timeUnit = timeUnit;
    }

    public void useGaps(Collection<Date> initSeries) {
        this.needGaps = true;
        series = new TreeSet<Date>(new Comparator<Date>() {
            @Override
            public int compare(Date key1, Date key2) {
                return DatePlotHelper.this.compare(key1, key2);
            }
        });
        series.addAll(initSeries);
    }

    public void useGaps() {
        this.needGaps = true;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public String formatKey(Date value) {
        return dateFormat.format(value);
    }

    @Override
    public Date nextKey(Date key) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(key);
        cal.add(timeUnit, period);
        return cal.getTime();
    }

    @Override
    public Date prevKey(Date key) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(key);
        cal.add(timeUnit, -period);
        return cal.getTime();
    }

    @Override
    public int compare(Date key1, Date key2) {
        return key1.compareTo(key2);
    }

    protected InterpolateMode getInterpolateMode() {
        return interpolateMode;
    }
}
