package ru.yandex.wmtools.common.data.plot;

import java.util.Comparator;

/**
 * Created by IntelliJ IDEA.
* User: senin
* Date: 29.10.2008
* Time: 20:16:05
*/
public interface PlotHelper<K, V> extends Comparator<K>{
    /**
     * Used if gaps needed.
     * Tells if specified specified key must be in the graph.
     * @param key
     * @return
     */
    boolean mustContainKey(K key);

    boolean isNeedGaps();

    /**
     * Format X values
     * @param value X value
     * @return string representation
     */
    String formatKey(K value);

    /**
     * Format Y values
     * @param value Y value
     * @return string representation
     */
    String formatValue(V value);

    /**
     * Compare X values
     * @param key1 first X value
     * @param key2 second X value
     * @return 0 if key1==key2, <0 if key1 < key2, >0 if key1 > key2
     */
    @Override
    int compare(K key1, K key2);

    /**
     * Used to create grid of X values.
     * In PlotDataWrapper all x in X MUST be on some grid, i.e. any x_i in X must be in G : x_0, nextKey(x_0), nextKey(nextKey(x_0)), ...
     * @param key current X value
     * @return next X value on the grid
     */
    K nextKey(K key);

    K prevKey(K key);

    public enum InterpolateMode {
        NULL,
        PREV,
        LINEAR,
        ZERO,
    }

    /**
     * Get Y value in case of missed data
     * @param key1 prev X value
     * @param value1 prev Y value
     * @param key2 next X value
     * @param value2 next Y value
     * @param key current X value
     * @return current Y value
     */
    V interpolate(K key1, V value1, K key2, V value2, K key);
}
