package ru.yandex.wmtools.common.data.plot;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Date;

/**
 * @author avhaliullin
 */
public class UnixTimestampDateFormat extends DateFormat {
    private final boolean inMillis;

    public UnixTimestampDateFormat(boolean inMillis) {
        this.inMillis = inMillis;
    }

    public UnixTimestampDateFormat() {
        this(false);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return toAppendTo.append(inMillis ? date.getTime() : date.getTime() / 1000);
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        return new Date(Long.valueOf(source) * (inMillis ? 1 : 1000));
    }
}
