package ru.yandex.wmtools.common.data.strategy;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.common.framework.pager.PagerFactory;
import ru.yandex.common.framework.pager.SimplePagerFactory;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;

/**
 * User: baton
 * Date: 26.11.2007
 * Time: 16:57:43
 */
public class OutputStrategy {
    private static final String PARAM_TYPE = "output_type";
    private static final String PARAM_VALUE_XML = "xml";

    private static final int DEFAULT_PAGE_SIZE = 25;

    private final OutputStrategyTypeEnum type;
    private final ServRequest req;
    private final PagerFactory pagerFactory;

    public OutputStrategy(ServRequest req, OutputStrategyTypeEnum type, PagerFactory pagerFactory) {
        this.req = req;
        this.type = type;
        this.pagerFactory = pagerFactory;
    }

    public OutputStrategy(ServRequest req, PagerFactory pagerFactory) throws UserException {
        this.req = req;
        this.pagerFactory = pagerFactory;

        String typeParam = req.getParam(PARAM_TYPE, true);
        if (typeParam == null) {
            type = OutputStrategyTypeEnum.VIEW;
        } else if (typeParam.equals(PARAM_VALUE_XML)) {
            type = OutputStrategyTypeEnum.EXPORT;
        } else {
            throw new UserException(UserProblem.ILLEGAL_PARAM_VALUE, "Invalid value of param 'type'.", PARAM_TYPE, typeParam);
        }
    }

    public OutputStrategy(ServRequest req, OutputStrategyTypeEnum type) {
        this(req, type, configurePagerFactory());
    }

    public OutputStrategy(ServRequest req) throws UserException {
        this(req, configurePagerFactory());
    }

    public Pager createPager() {
        return createPager(DEFAULT_PAGE_SIZE);
    }

    public Pager createPager(int pageSize) {
        switch (type) {
            case VIEW: {
                return pagerFactory.createPager(req, pageSize);
            }
            case EXPORT: {
                return null;
            }
            default: {
                throw new AssertionError("Unknown type: " + type);
            }
        }
    }

    public Pager createDefaultPager() {
        return pagerFactory.createPager(req);
    }

    public OutputStrategyTypeEnum getType() {
        return type;
    }

    private static PagerFactory configurePagerFactory() {
        SimplePagerFactory simplePagerFactory = new SimplePagerFactory();
        simplePagerFactory.setDefaultPageSize(DEFAULT_PAGE_SIZE);
        return simplePagerFactory;
    }
}
