package ru.yandex.wmtools.common.data.wrappers;

import ru.yandex.common.framework.user.UserInfo;
import ru.yandex.common.framework.user.blackbox.BlackBoxField;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author avhaliullin
 */
public class BlackBoxUserInfoWrapper extends XmlDataWrapper<UserInfo> {
    private static final String TAG_ROOT = "user";
    private static final String ATTRIBUTE_ID = "id";

    public BlackBoxUserInfoWrapper(UserInfo data) {
        this(data, TAG_ROOT);
    }

    public BlackBoxUserInfoWrapper(UserInfo data, String name) {
        super(data, name, ATTRIBUTE_ID, String.valueOf(data.getUserId()));
    }

    @Override
    protected void doToXml(StringBuilder result) {
        for (BlackBoxField field : BlackBoxField.values()) {
            String value = data.getValue(field.getUserInfoField());
            putTag(result, field.getUserInfoField().name().toLowerCase(), value);
        }
    }
}
