package ru.yandex.wmtools.common.data.wrappers;

import java.util.Date;

import ru.yandex.wmtools.common.util.XmlDataWrapper;

public class DateWrapper extends XmlDataWrapper<Date> {
    private static final String TAG_DATE = "date";
    private static final String TAG_SIMPLE = "simple";
    private static final String TAG_UNIX_TIMESTAMP = "unix-timestamp";

    public DateWrapper(Date date) {
        this(TAG_DATE, date);
    }

    public DateWrapper(String tag, Date date) {
        super(date, tag);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putDateTimeTag(result, TAG_SIMPLE, data);
        putUnixTimestampTag(result, TAG_UNIX_TIMESTAMP, data);
    }
}
