package ru.yandex.wmtools.common.data.wrappers;

import java.util.List;

import ru.yandex.wmtools.common.util.XmlDataWrapper;

public class DbIndexWrapper extends XmlDataWrapper<List<Integer>> {
    private static final String TAG_DB_INDEX = "db-index";

    public DbIndexWrapper(List<Integer> dbIndex) {
        super(dbIndex);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        StringBuilder sb = new StringBuilder();
        for (Integer i : data) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(i);
        }
        putTag(result, TAG_DB_INDEX, sb.toString());
    }
}
