package ru.yandex.wmtools.common.data.wrappers;

import ru.yandex.wmtools.common.data.info.HistoryInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 21:43:03
 */
public class HistoryInfoWrapper extends XmlDataWrapper<HistoryInfo> {
    private static final String TAG_ID = "id";
    private static final String TAG_USER = "user";
    private static final String TAG_OBJECT_USER = "object-user";
    private static final String TAG_VIRTUAL_USER = "virtual-user";
    private static final String TAG_ACTION = "action";
    private static final String TAG_OBJECT_ID = "object";
    private static final String TAG_PERFORMED_ON = "performed-on";
    private static final String TAG_TYPE = "type";
    private static final String TAG_NEW_VALUE = "new-value";

    public HistoryInfoWrapper(HistoryInfo data) {
        super(data, "history");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putLongTag(result, TAG_ID, data.getId());
        if (data.getUser() != null) {
            putComplexTag(result, TAG_USER, new UserInfoWrapper(data.getUser()), "id", Long.toString(data.getUser().getUserId()));
        }
        if (data.getVirtualUser() != null) {
            putComplexTag(result, TAG_VIRTUAL_USER, new UserInfoWrapper(data.getVirtualUser()), "id", Long.toString(data.getVirtualUser().getUserId()));
        }
        if (data.getObjectUser() != null) {
            putComplexTag(result, TAG_OBJECT_USER, new UserInfoWrapper(data.getObjectUser()), "id", Long.toString(data.getObjectUser().getUserId()));
        }
        putTag(result, TAG_ACTION, data.getAction().toString());
        putLongTag(result, TAG_OBJECT_ID, data.getObjectId());
        putExtendedDateTimeTag(result, TAG_PERFORMED_ON, data.getPerformedOn());
        putTag(result, TAG_TYPE, data.getType().toString());

        putTag(result, TAG_NEW_VALUE, data.getNewValue());
    }
}
