package ru.yandex.wmtools.common.data.wrappers;

import ru.yandex.wmtools.common.data.info.HostRegionInfo;
import ru.yandex.wmtools.common.data.info.HostRegionsInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author baton
 */
public class HostRegionsInfoWrapper extends XmlDataWrapper<HostRegionsInfo> {
    public HostRegionsInfoWrapper(HostRegionsInfo info) {
        super(info, "regions");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        if (data.getRegions() != null) {
            for (HostRegionInfo hostRegionInfo : data.getRegions()) {
                new RegionInfoWrapper(hostRegionInfo.getRegionInfo(), hostRegionInfo.getRegionType(), hostRegionInfo.isVisible()).toXml(result);
            }
        }
    }
}
