package ru.yandex.wmtools.common.data.wrappers;

import org.apache.commons.lang3.StringEscapeUtils;

import ru.yandex.wmtools.common.util.XmlDataWrapper;

public class IntegerWrapper extends XmlDataWrapper<Integer> {
    private static final String TAG_INTEGER = "integer";

    public IntegerWrapper(Integer value) {
        this(TAG_INTEGER, value);
    }

    public IntegerWrapper(String tag, Integer value) {
        super(value, tag);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        if (data != null) {
            result.append(StringEscapeUtils.escapeXml10(data.toString()));
        }
    }
}
