package ru.yandex.wmtools.common.data.wrappers;

import org.apache.commons.lang3.StringEscapeUtils;

import ru.yandex.wmtools.common.util.XmlDataWrapper;

public class LongWrapper extends XmlDataWrapper<Long> {
    private static final String TAG_LONG = "long";

    public LongWrapper(Long value) {
        this(TAG_LONG, value);
    }

    public LongWrapper(String tag, Long value) {
        super(value, tag);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        if (data != null) {
            result.append(StringEscapeUtils.escapeXml10(data.toString()));
        }
    }
}
