package ru.yandex.wmtools.common.data.wrappers;

import ru.yandex.wmtools.common.data.info.RegionInfoTreeNode;
import ru.yandex.wmtools.common.util.XmlDataWrapper;
import ru.yandex.wmtools.common.util.geobase.RegionInfoXmlSerializer;

/**
 * @author baton
 */
public class RegionInfoTreeNodeWrapper extends XmlDataWrapper<RegionInfoTreeNode> {
    private static final String TAG_REGION_NODE = "wmregion";
    private static final String ATTRIBUTE_ENABLED = "enabled";
    private static final String ATTRIBUTE_REGION_ID = "id";

    public RegionInfoTreeNodeWrapper(RegionInfoTreeNode data) {
        super(data, TAG_REGION_NODE, ATTRIBUTE_REGION_ID, Integer.toString(data.getRegionInfo().getId()), ATTRIBUTE_ENABLED, Boolean.toString(data.isEnabled()));
    }

    @Override
    protected void doToXml(StringBuilder result) {
        result.append(RegionInfoXmlSerializer.serialize(data.getRegionInfo()));

        for (RegionInfoTreeNode child : data.getChildren()) {
            new RegionInfoTreeNodeWrapper(child).toXml(result);
        }
    }
}
