package ru.yandex.wmtools.common.data.wrappers;

import ru.yandex.wmtools.common.data.RegionTypeEnum;
import ru.yandex.wmtools.common.data.info.RegionInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;
import ru.yandex.wmtools.common.util.geobase.RegionInfoXmlSerializer;

/**
 * @author baton
 */
public class RegionInfoWrapper extends XmlDataWrapper<RegionInfo> {
    private static final String TAG_REGION = "wmregion";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_VISIBLE = "visible";

    public RegionInfoWrapper(RegionInfo data) {
        super(data, TAG_REGION);
    }

    public RegionInfoWrapper(RegionInfo data, RegionTypeEnum type) {
        super(data, TAG_REGION, ATTRIBUTE_TYPE, Integer.toString(type.getId()));
    }

    public RegionInfoWrapper(RegionInfo data, RegionTypeEnum type, boolean visible) {
        super(data, TAG_REGION, ATTRIBUTE_TYPE, Integer.toString(type.getId()), ATTRIBUTE_VISIBLE, Boolean.toString(visible));
    }

    @Override
    protected void doToXml(StringBuilder result) {
        result.append(RegionInfoXmlSerializer.serialize(data));
    }
}
