package ru.yandex.wmtools.common.data.wrappers;

import org.apache.commons.lang3.StringEscapeUtils;

import ru.yandex.wmtools.common.util.XmlDataWrapper;

public class StringWrapper extends XmlDataWrapper<String> {
    private static final String TAG_STRING = "string";

    public StringWrapper(String value) {
        this(TAG_STRING, value);
    }

    public StringWrapper(String tag, String value) {
        super(value, tag);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        if (data != null) {
            result.append(StringEscapeUtils.escapeXml10(data));
        }
    }
}
