package ru.yandex.wmtools.common.data.wrappers;

import ru.yandex.wmtools.common.data.info.SupportUserInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 21:43:03
 */
public class SupportUserInfoWrapper extends XmlDataWrapper<SupportUserInfo> {
    private static final String TAG_LOGIN = "login";
    private static final String TAG_FIO = "fio";
    private static final String TAG_USER_DEFAULT = "user";

    public SupportUserInfoWrapper(SupportUserInfo data) {
        this(data, TAG_USER_DEFAULT);
    }

    public SupportUserInfoWrapper(SupportUserInfo data, String tagName) {
        super(data, tagName, "id", Long.toString(data.getUserId()));
    }

    @Override
    protected void doToXml(StringBuilder result) {
        if (data.getLogin() != null) {
            putTag(result, TAG_LOGIN, data.getLogin());
        }
        if (data.getFIO() != null) {
            putTag(result, TAG_FIO, data.getFIO());
        }
    }
}
