package ru.yandex.wmtools.common.data.wrappers;

import org.apache.commons.lang3.StringEscapeUtils;

import ru.yandex.wmtools.common.util.XmlDataWrapper;

public class TagWrapper extends XmlDataWrapper<String> {
    private static final String TAG_STRING = "string";

    public TagWrapper(String value) {
        super(TAG_STRING, value);
    }

    public TagWrapper(String tag, String value) {
        super(value, tag);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        result.append(StringEscapeUtils.escapeXml10(data));
    }
}
