package ru.yandex.wmtools.common.data.wrappers;

import ru.yandex.common.util.xml.XmlConvertable;
import ru.yandex.wmtools.common.data.info.WMUserInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 21:43:03
 */
public class UserInfoWrapper extends XmlDataWrapper<WMUserInfo> {
    private static final String TAG_LOGIN = "login";
    private static final String TAG_FIO = "fio";
    private static final String TAG_USER_DEFAULT = "user";

    private final XmlConvertable[] additionalInfo;

    public UserInfoWrapper(WMUserInfo data) {
        this(data, TAG_USER_DEFAULT);
    }

    public UserInfoWrapper(WMUserInfo data, String tagName, XmlConvertable... additionalInfo) {
        super(data, tagName, "id", Long.toString(data.getUserId()));
        this.additionalInfo = additionalInfo;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        if (data.getLogin() != null) {
            putTag(result, TAG_LOGIN, data.getLogin());
        }
        if (data.getFIO() != null) {
            putTag(result, TAG_FIO, data.getFIO());
        }
        if (additionalInfo != null && additionalInfo.length > 0) {
            for (XmlConvertable element : additionalInfo) {
                element.toXml(result);
            }
        }
    }
}
