package ru.yandex.wmtools.common.data.wrappers;

import ru.yandex.wmtools.common.data.info.VisitingStatInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 21:43:03
 */
public class VisitingStatInfoWrapper extends XmlDataWrapper<VisitingStatInfo> {
    private static final String TAG_USER = "user";
    private static final String TAG_REQUEST_TYPE = "request-type";
    private static final String TAG_REQUEST_DATE = "request-date";
    private static final String TAG_REQUESTS_COUNT = "count";

    public VisitingStatInfoWrapper(VisitingStatInfo data) {
        super(data, "stat");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putLongTag(result, TAG_USER, data.getUser());
        putTag(result, TAG_REQUEST_TYPE, data.getRequestTypeName(), "id", Integer.toString(data.getRequestTypeId()));
        putDateTag(result, TAG_REQUEST_DATE, data.getDate());
        putIntegerTag(result, TAG_REQUESTS_COUNT, data.getRequestsCount());
    }
}
