package ru.yandex.wmtools.common.data.xmlsearch;

import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.TimeFilter;

/**
 * Created by IntelliJ IDEA.
* User: senin
* Date: 01.12.2007
* Time: 15:36:38
*/
public class IntLinksRequest extends HostPathRequest {
    private static final String LINKINT_TEMPLATE = "(linkint:\"%1$s%3$s\" | linkint:\"%2$s%3$s\") (rhost:\"%4$s\" | rhost:\"%5$s\")";
    private static final String WHOLE_HOST_LINKINT_TEMPLATE = "(linkint:\"%1$s\" | linkint:\"%1$s/*\" | linkint:\"%2$s\" | linkint:\"%2$s/*\") (rhost:\"%3$s\" | rhost:\"%4$s\")";
    private static final String LINKINT_SHORT_TEMPLATE = "(linkint:\"%1$s%2$s\") (rhost:\"%3$s\" | rhost:\"%4$s\")";
    private static final String WHOLE_HOST_LINKINT_SHORT_TEMPLATE = "(linkint:\"%1$s\" | linkint:\"%1$s/*\") (rhost:\"%2$s\" | rhost:\"%3$s\")";


    public IntLinksRequest(String hostname, String path, int pageNum, int pageSize) throws UserException {
        super(hostname, path, pageNum, pageSize);
    }

    public IntLinksRequest(String hostName, String path, TimeFilter timeFilter, int pageNum, int pageSize)
            throws UserException {
        super(hostName, path, timeFilter, pageNum, pageSize);
    }

    @Override
    protected boolean separateProtocolAsScheme() {
        return false;
    }

    @Override
    protected String buildQuery(String rOwner1, String rOwner2) {
        String hostname = getHostname();

        String withOrWithoutWWW =
                hostname.startsWith(WWW_PREFIX) ? hostname.substring(4) : (WWW_PREFIX + hostname);
        String query = String.format(LINKINT_TEMPLATE, hostname, withOrWithoutWWW, getPath(), rOwner1, rOwner2);
        if (query.length() > MAX_REQUEST_LENGTH) {
            query = String.format(LINKINT_SHORT_TEMPLATE, hostname, getPath(), rOwner1, rOwner2);
        }
        return query;
    }

    @Override
    protected String buildWholeHostQuery(String rOwner1, String rOwner2) {
        String hostname = getHostname();

        String withOrWithoutWWW =
                hostname.startsWith(WWW_PREFIX) ? hostname.substring(4) : (WWW_PREFIX + hostname);
        String query = String.format(WHOLE_HOST_LINKINT_TEMPLATE, hostname, withOrWithoutWWW, rOwner1, rOwner2);
        if (query.length() > MAX_REQUEST_LENGTH) {
            query = String.format(WHOLE_HOST_LINKINT_SHORT_TEMPLATE, hostname, rOwner1, rOwner2);
        }
        return query;
    }


    @Override
    protected String getGroupByMode() {
        return GROUP_BY_MODE_FLAT;
    }

    @Override
    protected String getGroupByAttr() {
        return GROUP_BY_ATTR_EMPTY;
    }

    @Override
    public String getUrlParams() {
        return COMMON_PARAMS + "&" + PRON_PARAMS + "&" + RD0_RDBA0_PARAMS + "&" + LONGREQUEST1_PARAMS + "&" + RELEV_PARAMS;
    }
}
