package ru.yandex.wmtools.common.data.xmlsearch;

import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.TimeFilter;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 01.12.2007
 * Time: 16:00:39
 */
public class LinksCountRequest extends LinksRequest {
    public LinksCountRequest(String hostName) throws UserException {
        super(hostName, "*", 0, 10);
    }

    public LinksCountRequest(String hostName, String path, TimeFilter timeFilter, int pageNum, int pageSize) throws UserException {
        super(hostName, path, timeFilter, pageNum, pageSize);
    }

    public LinksCountRequest(String hostname, String path, int pageNum, int pageSize) throws UserException {
        super(hostname, path, pageNum, pageSize);
    }

    @Override
    protected String getGroupByMode() {
        return GROUP_BY_MODE_FLAT;
    }

    @Override
    protected String getGroupByAttr() {
        // FIXME: this will decrease count of links in results, but results will be in consistance with LinksGroupsRequest
        return GROUP_BY_ATTR_D;
    }

    @Override
    public String getUrlParams() {
        return COMMON_PARAMS + "&" + PRON_PARAMS + "&" + LONGREQUEST1_PARAMS + "&" + DBGWZR_PARAMS + "&" + RELEV_PARAMS;
    }
}
