package ru.yandex.wmtools.common.data.xmlsearch;

import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.TimeFilter;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 01.12.2007
 * Time: 16:00:39
 */
public class LinksFromHostRequest extends LinksRequest {
    private String fromHost;

    public LinksFromHostRequest(String hostName, String path, String fromHost, int pageNum, int pageSize)
            throws UserException {
        super(hostName, path, pageNum, pageSize);
        this.fromHost = fromHost;
    }

    public LinksFromHostRequest(String hostName, String path, TimeFilter timeFilter, String fromHost, int pageNum,
            int pageSize) throws UserException {
        super(hostName, path, timeFilter, pageNum, pageSize);
        this.fromHost = fromHost;
    }

    @Override
    protected String getGroupByMode() {
        return GROUP_BY_MODE_FLAT;
    }

    @Override
    protected String getGroupByAttr() {
        return GROUP_BY_ATTR_EMPTY;
    }

    @Override
    public String getUrlParams() throws InternalException {
        return COMMON_PARAMS + "&" + PRON_PARAMS + "&" + DBGWZR_PARAMS + "&" + LONGREQUEST1_PARAMS +
                "&surl=" + getOwnerDomain(fromHost) + "&" + RELEV_PARAMS;
    }
}
