package ru.yandex.wmtools.common.data.xmlsearch;

import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.TimeFilter;

/**
 * Created by IntelliJ IDEA.
* User: senin
* Date: 01.12.2007
* Time: 15:36:38
*/
public abstract class LinksRequest extends HostPathRequest {
    private static final String LINK_TEMPLATE = "(link:\"%1$s%3$s\" | link:\"%2$s%3$s\") ~~ (rhost:\"%4$s\" | rhost:\"%5$s\")";
    private static final String WHOLE_HOST_LINK_TEMPLATE = "(link:\"%1$s\" | link:\"%1$s/*\" | link:\"%2$s\" | link:\"%2$s/*\") ~~ (rhost:\"%3$s\" | rhost:\"%4$s\")";
    private static final String LINK_SHORT_TEMPLATE = "(link:\"%1$s%2$s\") ~~ (rhost:\"%3$s\" | rhost:\"%4$s\")";
    private static final String WHOLE_HOST_LINK_SHORT_TEMPLATE = "(link:\"%1$s\" | link:\"%1$s/*\") ~~ (rhost:\"%2$s\" | rhost:\"%3$s\") ";

    public LinksRequest(String hostname, String path, int pageNum, int pageSize) throws UserException {
        super(hostname, path, pageNum, pageSize);
    }

    public LinksRequest(String hostName, String path, TimeFilter timeFilter, int pageNum, int pageSize)
            throws UserException {
        super(hostName, path, timeFilter, pageNum, pageSize);
    }

    @Override
    protected boolean separateProtocolAsScheme() {
        return false;
    }

    @Override
    protected String buildQuery(String rOwner1, String rOwner2) {
        String hostname = getHostname();

        String withOrWithoutWWW =
                hostname.startsWith(WWW_PREFIX) ? hostname.substring(4) : (WWW_PREFIX + hostname);
        String query = String.format(LINK_TEMPLATE, hostname, withOrWithoutWWW, getPath(), rOwner1, rOwner2);
        if (query.length() > MAX_REQUEST_LENGTH) {
            query = String.format(LINK_SHORT_TEMPLATE, hostname, getPath(), rOwner1, rOwner2);
        }
        return query;
    }

    @Override
    protected String buildWholeHostQuery(String rOwner1, String rOwner2) {
        String hostname = getHostname();

        String withOrWithoutWWW =
                hostname.startsWith(WWW_PREFIX) ? hostname.substring(4) : (WWW_PREFIX + hostname);
        String query = String.format(WHOLE_HOST_LINK_TEMPLATE, hostname, withOrWithoutWWW, rOwner1, rOwner2);
        if (query.length() > MAX_REQUEST_LENGTH) {
            query = String.format(WHOLE_HOST_LINK_SHORT_TEMPLATE, hostname, rOwner1, rOwner2);
        }
        return query;
    }
}
