package ru.yandex.wmtools.common.data.xmlsearch;

import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.TimeFilter;

/**
 * Created by IntelliJ IDEA.
* User: senin
* Date: 01.12.2007
* Time: 15:36:38
*/
public class UrlsRequest extends HostPathRequest {
    private static final String URL_TEMPLATE = "url:\"%1$s%2$s\"";
    private static final String WHOLE_HOST_URL_TEMPLATE = "url:\"%1$s\" | url:\"%1$s/*\"";

    public UrlsRequest(String hostname, String path, int pageNum, int pageSize) throws UserException {
        super(hostname, path, pageNum, pageSize);
    }

    public UrlsRequest(String hostname, String path, TimeFilter timeFilter, int pageNum, int pageSize)
            throws UserException {
        super(hostname, path, timeFilter, pageNum, pageSize);
    }

    @Override
    protected boolean separateProtocolAsScheme() {
        return true;
    }

    @Override
    protected String buildQuery(String rOwner1, String rOwner2) {
        return String.format(URL_TEMPLATE, getHostname(), getPath());
    }

    @Override
    protected String buildWholeHostQuery(String rOwner1, String rOwner2) {
        return String.format(WHOLE_HOST_URL_TEMPLATE, getHostname());
    }

    @Override
    protected String getGroupByMode() {
        return GROUP_BY_MODE_FLAT;
    }

    @Override
    protected String getGroupByAttr() {
        return GROUP_BY_ATTR_EMPTY;
    }

    @Override
    public String getUrlParams() {
        return COMMON_PARAMS + "&" + PRON_PARAMS + "&" + RD0_RDBA0_PARAMS + "&" + LONGREQUEST1_PARAMS + "&" + RELEV_PARAMS;
    }
}
