package ru.yandex.wmtools.common.data.yt;


import ru.yandex.wmtools.common.util.HttpConnector.HttpMethod;

/**
 * @author avhaliullin
 */
public enum YTCommandEnum implements YTCommand {
    CREATE(HttpMethod.POST, "create", false),
    REMOVE(HttpMethod.POST, "remove", false),
    EXISTS(HttpMethod.GET, "exists", false),
    READ(HttpMethod.GET, "read", true),
    WRITE(HttpMethod.PUT, "write", true),
    MERGE(HttpMethod.POST, "merge", false),
    ERASE(HttpMethod.POST, "erase", false),
    MAP_REDUCE(HttpMethod.POST, "map_reduce", false),
    GET(HttpMethod.GET, "get", false),
    MOVE(HttpMethod.POST, "move", false),
    START_TX(HttpMethod.POST, "start_tx", false),
    PING_TX(HttpMethod.POST, "ping_tx", false),
    COMMIT_TX(HttpMethod.POST, "commit_tx", false),
    ABORT_TX(HttpMethod.POST, "abort_tx", false),
    LINK(HttpMethod.POST, "link", false),
    ;

    private final HttpMethod httpMethod;
    private final String code;
    private final boolean heavy;

    YTCommandEnum(HttpMethod httpMethod, String code, boolean heavy) {
        this.httpMethod = httpMethod;
        this.code = code;
        this.heavy = heavy;
    }

    public HttpMethod getHttpMethod() {
        return httpMethod;
    }

    public String getCode() {
        return code;
    }

    @Override
    public boolean isHeavy() {
        return heavy;
    }
}
