package ru.yandex.wmtools.common.error;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/**
 * @author baton
 */
public abstract class AbstractWMToolsException extends Exception {
    private final List<ExtraTagInfo> extraParams = new ArrayList<ExtraTagInfo>();

    public AbstractWMToolsException(String message, Throwable throwable, ExtraTagInfo ... extraParams) {
        super(message, throwable);
        this.extraParams.addAll(Arrays.asList(extraParams));
    }

    public Collection<ExtraTagInfo> getExtraParams() {
        return extraParams;
    }

    public ExtraTagInfo getExtraParam(ExtraTagNameEnum givenParam) {
        if (givenParam == null) {
            return null;
        }

        for (ExtraTagInfo param : extraParams) {
            if (givenParam.equals(param.getParam())) {
                return param;
            }
        }

        return null;
    }
}
