package ru.yandex.wmtools.common.error;

/**
 * @author avhaliullin
 */
public enum BlackboxProblem {
    OK(0),
    UNKNOWN(1),
    INVALID_PARAMS(2),
    DB_FETCHFAILED(9),
    DB_EXCEPTION(10),
    ACCESS_DENIED(21);

    private final int id;

    BlackboxProblem(int id) {
        this.id = id;
    }

    public int getId() {
        return id;
    }

    public static BlackboxProblem getById(int id) {
        for (BlackboxProblem e : values()) {
            if (e.getId() == id) {
                return e;
            }
        }
        return null;
    }
}
