package ru.yandex.wmtools.common.error;

/**
 * This exception represents a internal problem of the service when nothing useful could be said
 * to the user (like database unavailability). Generally this exception should be logged as an error
 * and some actions should be taken to solve a problem.
 *
 * @author ailyin
 */
public class InternalException extends AbstractWMToolsException {
    private final InternalProblem problem;

    /**
     * @param message message
     * @param throwable throwable
     * @param extraParams extra params
     *
     * @deprecated use another constructor
     */
    public InternalException(String message, Throwable throwable, ExtraTagInfo... extraParams) {
        super(message, throwable, extraParams);
        this.problem = null;    // make compiler happy
    }

    public InternalException(InternalProblem problem, String message, Throwable throwable,
                             ExtraTagInfo... extraParams) {
        super(message, throwable, extraParams);
        this.problem = problem;
    }

    public InternalException(InternalProblem problem, String message, ExtraTagInfo... extraParams) {
        this(problem, message, null, extraParams);
    }

    public InternalProblem getProblem() {
        return problem;
    }
}
