package ru.yandex.wmtools.common.error;

/**
 * Common internal problems.
 *
 * @author ailyin
 */
public enum InternalProblem {
    MESSAGING_ERROR,
    PROCESSING_ERROR,

    READ_DB_ERROR(true),
    WRITE_DB_ERROR(true),
    MASTER_DB_BANNED(true),
    WRITE_FILE_ERROR,
    READ_FILE_ERROR,

    SETTINGS_LOAD_FAILED,   // remove?
    MAIL_SEND_FAILURE,

    // offline links
    SECRET_STRING_NOT_FOUND,

    //serplinks
    INTERNAL_PROBLEM,
    CONNECTION_PROBLEM,

    // speller
    YANDEX_SPELLER_ERROR,
    CANT_GET_HTML,

    // new
    SERVANT_FAILED,
    ILLEGAL_ARGUMENT,
    TMS_INITIALIZATION_PROBLEM,
    REGIONS_INITIALIZATION_PROBLEM,
    NO_SUCH_USER_IN_PASSPORT,

    //todo move it from wmtools to xml
    TOO_MUCH_DIFFERENCE_IN_PARTNERS, // xml

    JAXB_MARSHALLING_ERROR;

    private final boolean isDbError;

    InternalProblem() {
        this.isDbError = false;
    }

    InternalProblem(boolean isDbError) {
        this.isDbError = isDbError;
    }

    public boolean isDbError() {
        return isDbError;
    }
}
