package ru.yandex.wmtools.common.error;

/**
 * This exception represents a situation when requested action couldn't be performed due to incorrect
 * or illegal user behaviour. Generally an error indicated by this exception should be reported to the user.
 *
 * @see IUserProblem
 * @author ailyin
 */
public class UserException extends AbstractWMToolsException {
    private final IUserProblem problem;

    public UserException(IUserProblem problem, String message, Throwable throwable, ExtraTagInfo... extraParams) {
        super(message, throwable, extraParams);
        this.problem = problem;
    }

    public UserException(IUserProblem problem, String message, ExtraTagInfo... extraParams) {
        this(problem, message, null, extraParams);
    }

    public UserException(IUserProblem error, String message, String paramName) {
        this(error, message, new ExtraTagInfo(ExtraTagNameEnum.PARAM, paramName));
    }

    public UserException(IUserProblem error, String message, String paramName, String paramValue) {
        this(error, message, new ExtraTagInfo(ExtraTagNameEnum.PARAM, paramName), new ExtraTagInfo(ExtraTagNameEnum.VALUE, paramValue));
    }

    public UserException(IUserProblem error, String message, Throwable cause, String paramName) {
        this(error, message, cause, new ExtraTagInfo(ExtraTagNameEnum.PARAM, paramName));
    }

    public UserException(IUserProblem error, String message, Throwable cause, String paramName, String paramValue) {
        this(error, message, cause, new ExtraTagInfo(ExtraTagNameEnum.PARAM, paramName), new ExtraTagInfo(ExtraTagNameEnum.VALUE, paramValue));
    }

    public IUserProblem getProblem() {
        return problem;
    }
}
