package ru.yandex.wmtools.common.error;

/**
 * Common user problems.
 *
 * @author ailyin
 */
public enum UserProblem implements IUserProblem {
    // former ServantletErrors
    OPERATION_NOT_PERMITTED,
    TOO_BIG_ATTACHMENT,

    NO_SUCH_USER_IN_PASSPORT(34),
    USER_NOT_SIGNED_IN(35),
    USER_NOT_PERMITTED,
    NO_SUCH_USER_IN_SERVICE(31),
    TWO_OR_MORE_USERS_WITH_SUCH_HOSTNAME,

    // params
    INVALID_PARAM(37),
    ILLEGAL_PARAM_VALUE(37),
    ILLEGAL_VALUE_TYPE(37),
    SUCH_VALUE_NOT_ALLOWED_HERE(37),
    PARAM_NOT_ALLOWED(37),
    REQUIRED_PARAM_MISSED(37),
    INVALID_PATH,
    INVALID_URL,
    HOST_NAME_TOO_LONG,
    URL_TOO_LONG,
    IP_ADDRESSES_FORBIDDEN,
    WRONG_PROTOCOL_USED,
    WRONG_HOSTNAME_USED,

    HOST_NOT_FOUND_IN_DATABASE,

    // top errors
    NO_SUCH_REGION_FOR_DATE,
    INVALID_TOP_DATE,

    // custom regions
    SUCH_CUSTOM_REGION_ALREADY_ADDED,
    TOO_MANY_CUSTOM_REGIONS_FOR_HOST,
    NO_SUCH_CUSTOM_REGION_FOUND,

    // email validation
    EMAIL_NOT_VERIFIED,

    // custom queries
    SUCH_CUSTOM_QUERY_ALREADY_ADDED,
    TOO_MANY_CUSTOM_QUERIES_FOR_HOST,
    NO_SUCH_CUSTOM_QUERY_FOUND,
    CUSTOM_QUERY_IS_TOO_LARGE,
    CUSTOM_QUERY_IS_EMPTY,

    // former ServiceErrors
    USER_IS_BLOCKED(30),
    USER_HAVENT_ACCEPTED_LICENCE,
    USER_IS_ALREADY_IN_LIST,

    //main mirror
    CANT_CHANGE_MAIN_MIRROR,

    // redirection for robots.txt
    ROBOTS_TXT_REDIRECTED,

    // sitemap size limit exceeded
    SITEMAP_TOO_LONG,

    ZORA_REQUEST_TOO_FREQUENT,
    ZORA_UNSPECIFIED_ERROR,

    // limits
    USER_IS_NOT_MAIN_OWNER,
    MAIN_USER_NOT_FOUND,
    DELEGATION_NOT_ALLOWED_TWICE,
    DELEGATION_NOT_TO_OWNER_NOT_ALLOWED,
    UNABLE_TO_REVOKE_LIMIT_FROM_SITE_OWNER,
    NO_DELEGATION_FOR_HOST,
    LIMIT_DELEGATION_COUNT_LIMIT_EXCEEDED;

    private final Integer id;

    private UserProblem() {
        this.id = null;
    }

    private UserProblem(int id) {
        this.id = id;
    }

    @Override
    public Integer getId() {
        return id;
    }
}
